#!/bin/bash
mkdir -p /var/log/serverg

echo -n "Fixing permissions..."
chown -R sgadmin:sgadmin /etc/serverg
usermod -a -G adm sgadmin
#sed -i '/python3/d' ~sgadmin/.bashrc
#echo "alias python3='/usr/bin/python3'" >> ~sgadmin/.bashrc
echo "OK"

cd /opt/tg-dashboard
if [ -d /opt/tg-dashboard/flask-venv ]; then
	exit
fi
python3 -m venv flask-venv
source /opt/tg-dashboard/flask-venv/bin/activate

echo -n "Install basic modules ..."
	python3 -m pip install flask sshpubkeys python-dateutil oauth2client
echo "OK"

# pexpect
echo -n "Checking pexpect..."
VTXT=`python3 -m pip show pexpect | grep Version`
VER=(${VTXT// / })
if [ "${VER[1]}" = '4.7.0' ]; then
	echo 'OK'
else    
	echo -n "Installing..."
	python3 -m pip install pexpect==4.7.0 1>/dev/null
	echo 'OK'
fi

# pycryptdome
echo -n "Checking pycryptdome..."
python3 -m pip show pycryptodome 1>/dev/null
if [ $? -eq 0 ]; then
	echo "OK"
else
	echo -n "Installing..."
	python3 -m pip install pycryptodome 1>/dev/null
	echo "OK"
fi

# psutil
echo -n "Checking psutil..."
python3 -m pip show psutil 1>/dev/null
if [ $? -eq 0 ]; then
	echo "OK"
else
	echo -n "Installing..."
	python3 -m pip install psutil 1>/dev/null
	echo "OK"
fi

# python-pam
echo -n "Checking python-pam..."
python3 -m pip show python-pam 1>/dev/null
if [ $? -eq 0 ]; then
	echo "OK"
else
	echo -n "Installing..."
	python3 -m pip install python-pam 1>/dev/null
	echo "OK"
fi

# pyconcrete
#echo -n "Checking pyconcrete..."
#python3 -m pip show pyconcrete 1>/dev/null
#if [ $? -eq 0 ]; then
#	echo "OK"
#else
#	echo -n "Installing..."
#	PYCONCRETE_PASSPHRASE=TG_dashboard python3 -m pip install pyconcrete 1>/dev/null <<EOF
#
#
#EOF
#	echo "OK"
#fi

# google-cloud
echo -n "Checking google-cloud..."
python3 -m pip show google-cloud 1>/dev/null
if [ $? -eq 0 ]; then
	echo "OK"
else
	echo -n "Installing..."
	python3 -m pip install google-cloud 1>/dev/null
	echo "OK"
fi

# gsutil
#echo -n "Checking gsutil..."
#python3 -m pip show gsutil 1>/dev/null
#if [ $? -eq 0 ]; then
#	python3 -m pip install crcmod 1>/dev/null
#	echo "OK"
#else
#	echo -n "Installing..."
#	python3 -m pip install crcmod multidict typing_extensions yarl async_timeout attrs charset_normalizer aiosignal 1>/dev/null
#	python3 -m pip install gsutil 1>/dev/null
#	echo "OK"
#fi

# google-cloud-storage
echo -n "Checking google-cloud-storage..."
python3 -m pip show google-cloud-storage 1>/dev/null
if [ $? -eq 0 ]; then
	echo "OK"
else
	echo -n "Installing..."
	python3 -m pip install google-cloud-storage 1>/dev/null
	echo "OK"
fi

# google-api-python-client
echo -n "Checking google-api-python-client..."
python3 -m pip show google-api-python-client 1>/dev/null
if [ $? -eq 0 ]; then
	echo "OK"
else
	echo -n "Installing..."
	python3 -m pip install google-api-python-client 1>/dev/null
	echo "OK"
fi

# google-auth-oauthlib
echo -n "Checking google-auth-oauthlib..."
python3 -m pip show google-auth-oauthlib 1>/dev/null
if [ $? -eq 0 ]; then
	echo "OK"
else
	echo -n "Installing..."
	python3 -m pip install google-auth-oauthlib 1>/dev/null
	echo "OK"
fi

echo -n 'Initializing user, group and dir...'
{
	groupadd tg-upload 2>&1;
	groupadd tg-download 2>&1;
	useradd -d /home/uploader -g tg-upload -s /usr/sbin/nologin uploader 2>&1;
	useradd -d /home/downloader -g tg-download -s /usr/sbin/nologin downloader 2>&1;
	mkdir -p /home/nfs;
	mkdir -p /home/smb;
	mkdir -p /home/uploader/upload;
	mkdir -p /home/downloader/download;
	mkdir -p /home/uploader/dev;
	mkdir -p /home/downloader/dev;
	chmod 2755 /home/uploader/dev;
	chmod 2755 /home/downloader/dev;
	chown uploader:tg-upload /home/uploader/upload;
	chown downloader:tg-download /home/downloader/download;
	chown -R sgadmin:sgadmin /etc/serverg;
} >> /var/log/serverg/tg-init.log
echo 'OK'

echo -n 'Checking sgadmin private key...'
if [ ! -f /home/sgadmin/.ssh/id_rsa ]; then
	echo -n 'Creating...'
	if [ ! -d /home/sgadmin/.ssh ]; then
		mkdir /home/sgadmin/.ssh
	fi
	ssh-keygen -t rsa -b 4096 -f /home/sgadmin/.ssh/id_rsa -N '' 2>&1 >> /var/log/serverg/tg-init.log
	cat /home/sgadmin/.ssh/id_rsa.pub > /home/sgadmin/.ssh/authorized_keys
	chown -R sgadmin.sgadmin /home/sgadmin/.ssh
	chmod 600 /home/sgadmin/.ssh/id_rsa
	echo 'OK'
else
	echo 'OK'
fi

echo -n 'Adding SSH settings...'
if [ -f /home/sgadmin/.ssh/config ]; then
	sed -i -e '/START TG SSH/,/END TG SSH/d' /home/sgadmin/.ssh/config
fi
cat << EOF >> /home/sgadmin/.ssh/config
## START TG SSH ##
Host *
  StrictHostKeyChecking no
  UserKnownHostsFile /dev/null
  LogLevel quiet
## END TG SSH ##
EOF
chown -R sgadmin.sgadmin /home/sgadmin/.ssh/config
echo 'OK'

echo -n 'Adding SFTP settings...'
# Check if the existing settings are not present
if ! grep -q '## START TG SFTP ##' /etc/ssh/sshd_config; then
    # Add new TG SFTP settings
    cat << EOF >> /etc/ssh/sshd_config
## START TG SFTP ##
Match Group tg-upload
        ForceCommand /bin/false

Match Group tg-download
        ForceCommand /bin/false
## END TG SFTP ##
EOF
    echo 'OK'
else
    echo 'already exist.'
fi

# Path to sshd_config
echo -n 'Adding SSH pubkey settings...'
sshd_config="/etc/ssh/sshd_config"

# Config to add
config_to_add=".ssh/tg.pub"

# Check if AuthorizedKeysFile with .ssh/tg.pub exists and add if not
if ! grep -q "^AuthorizedKeysFile.*\.ssh/tg\.pub" "$sshd_config"; then
    # Check if AuthorizedKeysFile exists
    if grep -q "^AuthorizedKeysFile" "$sshd_config"; then
	sed -i -e "/^AuthorizedKeysFile/ s/\$/ .ssh\/tg.pub/" "$sshd_config"
	echo "Added to current configuration."
    else
        echo "Match All" >> "$sshd_config"
        echo "AuthorizedKeysFile .ssh/authorized_keys $config_to_add" >> "$sshd_config"
	echo "Added new line."
    fi
else
    echo "OK"
fi


echo -n 'Creating rsyslog settings...'
cat << EOF > /etc/rsyslog.d/tg-sftp.conf
# create additional sockets for the sftp chrooted users
#module(load="imuxsock")
input(type="imuxsock" Socket="/home/uploader/dev/log" CreatePath="on")
input(type="imuxsock" Socket="/home/downloader/dev/log" CreatePath="on")

# log internal-sftp activity to sftp.log
if \$programname == 'internal-sftp' then /var/log/sftp.log
& stop
EOF
echo 'OK'

echo -n 'Configureing apache2 settings...'
{
	a2ensite tg-dashboard;
	a2enmod rewrite;
	a2enmod ssl;
	a2dissite 000-default;
} 2>&1 >> /var/log/serverg/tg-init.log
echo 'OK'

echo -n 'Restarting services...'
{
	systemctl restart ssh;
	systemctl restart rsyslog;
	systemctl restart apache2;
} 2>&1 >> /var/log/serverg/tg-init.log
echo 'OK'
