#!/opt/tg-dashboard/flask-venv/bin/python

import pexpect
import time, os, configparser, subprocess
import logging

fmt = "%(asctime)s %(levelname)s %(message)s"
logging.basicConfig(filename='/var/log/serverg/gcloud-init.log', level=logging.DEBUG, format=fmt)

timeout = time.time() + 180
code_path = '/etc/serverg/tg-config/gcloud_verification_code'
auth_path = '/etc/serverg/tg-config/gcloud_auth_url'
conf_path = '/etc/serverg/tg-config/tgm.conf'
log_path = '/var/log/serverg/gcloud-configure.log'
pid_file = '/var/log/serverg/gcloud_get_vcode.pid'

pid = os.getpid()
with open(pid_file, mode="w") as f:
    f.write(str(pid))

if os.path.exists(code_path):
    os.system('rm {0}'.format(code_path))

logging.debug('START: gcloud auth application-default login')

with open(log_path, 'ab') as log_file:
    child = pexpect.spawn('sudo -u sgadmin gcloud auth application-default login --no-launch-browser --quiet --disable-quota-project')
    child.logfile = log_file

    child.expect('Go to the following link in your browser, and complete the sign-in prompts:')
    child.expect('Once finished, enter the verification code provided in your browser:')
    auth_url = child.before.decode('utf-8').strip()
    with open(auth_path, mode="w") as f:
        f.write(auth_url)

    while True:
        if time.time() > timeout:
            logging.info('Timeout')
            exit()
        if os.path.exists(code_path):
            time.sleep(1)
            with open(code_path, 'r') as f:
                vcode = f.read().strip()
            break

    logging.info('FOUND verification code: {0}'.format(vcode))
    child.sendline(vcode)
    child.expect(pexpect.EOF)
    logging.info(child.before.decode('utf-8'))
    child.close()
    os.system('sudo chown sgadmin /home/sgadmin/.config/gcloud/application_default_credentials.json')
